VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.1#0"; "mscomctl.ocx"
Begin VB.UserControl ArmCheckView0 
   ClientHeight    =   3975
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   5265
   ScaleHeight     =   3975
   ScaleWidth      =   5265
   ToolboxBitmap   =   "A_chekvw0.ctx":0000
   Begin MSComctlLib.ListView ListView 
      Height          =   3615
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4815
      _ExtentX        =   8493
      _ExtentY        =   6376
      View            =   3
      LabelEdit       =   1
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      HideColumnHeaders=   -1  'True
      FullRowSelect   =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   16777215
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin VB.Menu MenuPopup 
      Caption         =   ""
   End
   Begin VB.Menu PopupMenu 
      Caption         =   "Set rep as special"
   End
End
Attribute VB_Name = "ArmCheckView0"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'HISTORY
'1.1.4  Fixed clear method - will clear also the collection not only view
'1.1.5  Added Enabled property, SaveItem - first save unchecked then checked, ClearListView unchecks collection
'1.1.6  Changed LoadList to load according parameter and not actual mode.
'       Removed update collection in edit mode, should not be used.
'1.1.7  Fixed UnCheckCollection from ClearListView (removed)
'1.1.8  Added Add method, bold items and grayed readonly items
'2.8.2 Added event Loaded (JN)
Option Explicit

'In order to avoid thousand of line in the checkview (1000 lines = 30 s.)

'fired when control is resized
Public Event Resize()
'fired when control is clicked
Public Event Click()
'fired when control is double clicked
Public Event DblClick()
'fired when node is collapsed
Public Event KeyDown(KeyCode As Integer, Shift As Integer)
'fired when key is pressed
Public Event KeyPress(KeyAscii As Integer)
'fired when key is up
Public Event KeyUp(KeyCode As Integer, Shift As Integer)
'fired when node is checked
Public Event ItemCheck(ByVal Item As MSComctlLib.ListItem)
'fired when node is clicked
Public Event ItemClick(ByVal Item As MSComctlLib.ListItem)

Public Event ItemSave(ByVal lo_ItemInfo As ItemInfo, ByVal Master As Variant, ByVal Detail As Variant, ByVal Checked As Boolean, ByRef Saved As Boolean)
Public Event ItemAdded(ByVal Master As Variant, ByVal Detail As Variant)

Public Event ItemLoaded(ByVal Item As MSComctlLib.ListItem)

'windows API call from user32 to send message to a window (control)
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" _
                            (ByVal hwnd As Long, _
                            ByVal wMsg As Long, _
                            wParam As Any, _
                           lParam As Any) As Long   ' <--- !!

Private Const LVM_FIRST = &H1000
Private Const LVM_GETCOLUMNWIDTH = LVM_FIRST + 29
Private Const LVM_SETCOLUMNWIDTH = LVM_FIRST + 30
Private Const LVSCW_AUTOSIZE = -1
Private Const LVSCW_AUTOSIZE_USEHEADER = -2

'Curseur & donnes
Private mo_ArmDb As Object
Private mb_Created As Boolean
Private mb_use_framework_connection As Boolean
Private ms_ConnectString As String
Private ms_UID As String

Private mv_ViewRequest As Variant
Private mv_EditRequest As Variant
Private mv_CheckRequest As Variant
Private mv_UnCheckRequest As Variant
Private mu_Mode As ListLoadMode
Private mo_ItemCollection As New Collection
Private mv_HeaderNames As Variant
Private ml_Columns As Long
Private mv_MasterID As Variant
Private mb_ItemsLoaded As Boolean
Private m_Language As String
Public MasterField As Variant

Private mo_UI As New clsComUI

'Tree load type enumeration
Public Enum ListLoadMode
  ModeView
  ModeEdit
End Enum


Public Property Set ArmDb(ByRef ao_local_connection As Object)
    
    If Not (ao_local_connection Is Nothing) Then
        Set mo_ArmDb = ao_local_connection
        mb_use_framework_connection = True
    End If
    
End Property


Property Let ConnectString(as_ConnectString As String)
    
    ms_UID = ConnectionStringValidation(as_ConnectString)
    If ms_UID = "" Then Exit Property
    
    ms_ConnectString = as_ConnectString
    
End Property

Property Let Language(ALanguage As String)
    
    m_Language = ALanguage
    
End Property

Private Sub ListView_Click()
  RaiseEvent Click
End Sub

Private Sub ListView_DblClick()
  RaiseEvent DblClick
End Sub

Private Sub ListView_ItemCheck(ByVal Item As MSComctlLib.ListItem)
  If Item.Tag.ReadOnly Then
    Item.Checked = Not Item.Checked
  Else
    RaiseEvent ItemCheck(Item)
  End If
  
  
  
End Sub

Private Sub ListView_ItemClick(ByVal Item As MSComctlLib.ListItem)
  RaiseEvent ItemClick(Item)
End Sub

Public Property Get SelectedItem() As ListItem
    Set SelectedItem = ListView.SelectedItem
    End Property



Private Sub ListView_KeyDown(KeyCode As Integer, Shift As Integer)
  RaiseEvent KeyDown(KeyCode, Shift)
End Sub

Private Sub ListView_KeyPress(KeyAscii As Integer)
  RaiseEvent KeyPress(KeyAscii)
End Sub

Private Sub ListView_KeyUp(KeyCode As Integer, Shift As Integer)
  RaiseEvent KeyUp(KeyCode, Shift)
End Sub

Public Sub Load_A_COM()
  
    VerifyInitialization mo_ArmDb, ms_ConnectString, m_Language, Me
  
  mv_EditRequest = ""
  mv_ViewRequest = ""
  Columns = 1
  mu_Mode = ListLoadMode.ModeView
  mb_ItemsLoaded = False

End Sub

Private Sub UserControl_Resize()
  With ListView
    .Height = Height
    .Width = Width
    .Top = 0
    .Left = 0
  End With
  RaiseEvent Resize
End Sub

Public Property Get ViewRequest() As Variant
  ViewRequest = mv_ViewRequest
End Property

Public Property Let ViewRequest(ByVal vNewValue As Variant)
  mv_ViewRequest = vNewValue
End Property

Public Property Get EditRequest() As Variant
  EditRequest = mv_EditRequest
End Property

Public Property Let EditRequest(ByVal vNewValue As Variant)
  mb_ItemsLoaded = False
  mv_EditRequest = vNewValue
End Property

Public Property Get CheckRequest() As Variant
  CheckRequest = mv_CheckRequest
End Property

Public Property Let CheckRequest(ByVal vNewValue As Variant)
  mv_CheckRequest = vNewValue
End Property

Public Property Get UnCheckRequest() As Variant
  UnCheckRequest = mv_UnCheckRequest
End Property

Public Property Let UnCheckRequest(ByVal vNewValue As Variant)
  mv_UnCheckRequest = vNewValue
End Property

Public Property Get MasterID() As Variant
    MasterID = mv_MasterID
End Property

Public Property Let MasterID(ByVal vNewValue As Variant)
    mv_MasterID = vNewValue
End Property

Public Sub Clear()
    Call ClearListView
    Call mo_UI.ClearCollection(mo_ItemCollection)
    mb_ItemsLoaded = False
End Sub

Public Function InitList() As Boolean

    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then Exit Function
    If mo_UI.IsValidCursor(mv_EditRequest) Then
        InitList = LoadCursorEdit(mv_EditRequest)
    Else
        Mode = ListLoadMode.ModeEdit
        InitList = LoadRequest(mv_EditRequest)
    End If

End Function

Public Function LoadList() As Boolean
Dim ll_cursor As Long

    LoadList = False
    On Error GoTo CleanUp_Err

    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then Exit Function
    Screen.MousePointer = vbHourglass
    
    Select Case mu_Mode
        Case ListLoadMode.ModeEdit
            If mo_UI.IsValidCursor(EditRequest) Then
                LoadList = LoadCursorEdit(EditRequest)
            Else
                LoadList = LoadRequest(EditRequest)
            End If
    Case ListLoadMode.ModeView
            If mo_UI.IsValidCursor(ViewRequest) Then
                LoadList = LoadCursorView(ViewRequest)
            Else
                LoadList = LoadRequest(ViewRequest)
            End If
    End Select
    Call Display

CleanUp_Err:
    Screen.MousePointer = vbDefault
End Function

Public Function Refresh() As Boolean

    mb_ItemsLoaded = False
    If mo_UI.IsValidCursor(EditRequest) Then
        Refresh = LoadCursorView(EditRequest)
    Else
        Mode = ListLoadMode.ModeEdit
        Refresh = LoadRequest(EditRequest)
    End If
    If mo_UI.IsValidCursor(ViewRequest) Then
        Refresh = LoadCursorView(ViewRequest)
    Else
        Mode = ListLoadMode.ModeView
        Refresh = LoadRequest(ViewRequest)
    End If
    Call Display
End Function

Private Function LoadRequest(ByVal ls_Request As String) As Boolean
Dim ll_cursor As Long

    LoadRequest = False
    
    'Try connection, 'use_framework_connection' is inside 'ASC_ConnectToDB' !
    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then Exit Function
    If ls_Request <> "" Then
        ll_cursor = mo_ArmDb.OpenSQL(mo_UI.ReplacePlaceHolder(ls_Request, 0, MasterID))
        If ll_cursor Then
            Select Case mu_Mode
                Case ListLoadMode.ModeEdit
                    LoadRequest = LoadCursorEdit(ll_cursor)
        Case ListLoadMode.ModeView
                    LoadRequest = LoadCursorView(ll_cursor)
            End Select
            Call mo_ArmDb.Close(ll_cursor)
        End If
    End If
End Function

Private Function FindCollectionItem(ByRef ItemID As Variant) As ItemInfo
Dim lo_ItemInfo As ItemInfo
Dim ll_Index As Long

    Set FindCollectionItem = Nothing
    For ll_Index = 1 To mo_ItemCollection.Count
        Set lo_ItemInfo = mo_ItemCollection(ll_Index)
        If CStr(lo_ItemInfo.Id) = CStr(ItemID) Then
            Set FindCollectionItem = lo_ItemInfo
            Exit For
        End If
    Next
End Function

Private Sub UncheckCollection()
Dim lo_ItemInfo As ItemInfo
Dim ll_Index As Long

    For ll_Index = 1 To mo_ItemCollection.Count
      Set lo_ItemInfo = mo_ItemCollection(ll_Index)
      lo_ItemInfo.Checked = False
    Next
End Sub

Private Sub AddCollectionItem(ByVal ll_cursor As Long, lb_Checked As Boolean)
Dim lo_ItemInfo As ItemInfo
Dim ll_Index As Long

    Set lo_ItemInfo = New ItemInfo
    lo_ItemInfo.Id = mo_ArmDb.GetFields(ll_cursor, 0)
    lo_ItemInfo.Caption = mo_ArmDb.GetFields(ll_cursor, 1)

' Ne pas mettre en commentaire cette partie !!!!!!!!!!
' Primordial pour le fonctionnement de la online
    If mo_ArmDb.FieldCount(ll_cursor) >= 3 Then
        If Trim$(UCase$(mo_ArmDb.GetFields(ll_cursor, 2))) = "Y" Or Trim$(UCase$(mo_ArmDb.GetFields(ll_cursor, 2))) = "X" Then
            lo_ItemInfo.Checked = True
        Else
            lo_ItemInfo.Checked = False
        End If
    Else
        lo_ItemInfo.Checked = lb_Checked
    End If
    
    lo_ItemInfo.ReadOnly = False
    lo_ItemInfo.DataChanged = False
    
    If Columns > 1 Then
        Call lo_ItemInfo.SetDataSize(Columns - 2)
        Call UpdateCollectionItemData(lo_ItemInfo, ll_cursor)
    End If
    
    Call mo_ItemCollection.Add(lo_ItemInfo)
    
End Sub

Private Sub UpdateCollectionItemData(ByVal lo_ItemInfo As ItemInfo, ByVal ll_cursor As Long)
Dim ll_Index As Long

    If (mo_ArmDb.FieldCount(ll_cursor) > 2) And (Columns > 1) Then
        For ll_Index = 0 To lo_ItemInfo.length
            Call lo_ItemInfo.SetData(ll_Index, mo_ArmDb.GetFields(ll_cursor, ll_Index + 2))
        Next
    End If
End Sub

Private Function LoadCollection(ll_cursor As Long, lb_Checked As Boolean) As Boolean
    LoadCollection = False
    Call mo_UI.ClearCollection(mo_ItemCollection)
  
'TODO: Change dans la nouvelle version du armcheckview
    If mo_ArmDb.FieldCount(ll_cursor) >= 2 Then
'    If mo_ArmDb.FieldCount(ll_Cursor) >= 1 Then
        Call mo_ArmDb.First(ll_cursor)
        While Not mo_ArmDb.EOF(ll_cursor)
            Call AddCollectionItem(ll_cursor, lb_Checked)
            Call mo_ArmDb.Next(ll_cursor)
        Wend
        LoadCollection = True
    End If

End Function

Private Function LoadCursorEdit(ByVal ll_cursor As Long) As Boolean
Dim lo_ItemInfo As ItemInfo
Dim ll_Index As Long
Dim ItemID As Variant

    LoadCursorEdit = False
      
    If mo_ArmDb.FieldCount(ll_cursor) >= 2 Then
        Call LoadCollection(ll_cursor, False)
    Else
        LoadCursorEdit = False
    End If
    mb_ItemsLoaded = True
End Function

Private Function LoadCursorView(ByVal ll_cursor As Long) As Boolean
Dim lo_ItemInfo As ItemInfo
Dim ItemID As Variant
  
    LoadCursorView = True
  
    If mb_ItemsLoaded Then
        Call UncheckCollection
        If mo_ArmDb.FieldCount(ll_cursor) >= 1 Then
            Call mo_ArmDb.First(ll_cursor)
            While Not mo_ArmDb.EOF(ll_cursor)
                ItemID = mo_ArmDb.GetFields(ll_cursor, 0)
                Set lo_ItemInfo = FindCollectionItem(ItemID)
                If lo_ItemInfo Is Nothing Then
                    LoadCursorView = False        'here is a problem, view item was not found in edit ... I will not add
                Else
                lo_ItemInfo.Checked = True
                Call UpdateCollectionItemData(lo_ItemInfo, ll_cursor)
                End If
                Call mo_ArmDb.Next(ll_cursor)
            Wend
        End If
    Else
        Call LoadCollection(ll_cursor, True)
    End If
End Function


Public Property Get Mode() As ListLoadMode
  Mode = mu_Mode
End Property

Public Property Let Mode(ByVal vNewValue As ListLoadMode)
  mu_Mode = vNewValue
  Call Display
End Property

Private Sub AddListItem(ByRef lo_ItemInfo As ItemInfo)
Dim lo_ListItem As ListItem
Dim ll_Index As Long

  Set lo_ListItem = ListView.ListItems.Add
  lo_ListItem.Text = lo_ItemInfo.Caption
  'lo_ListItem.Bold = True
  lo_ListItem.Checked = lo_ItemInfo.Checked
  If lo_ItemInfo.ReadOnly Then lo_ListItem.ForeColor = vbGrayText
  If lo_ItemInfo.length >= 0 Then
    For ll_Index = 0 To lo_ItemInfo.length
      Call lo_ListItem.ListSubItems.Add(, , CStr(lo_ItemInfo.GetData(ll_Index)), , "")
    Next
  End If
  Set lo_ListItem.Tag = lo_ItemInfo
  RaiseEvent ItemLoaded(lo_ListItem)
End Sub

Private Sub ClearListView()
  ListView.ListItems.Clear
End Sub

Public Sub Display()
Dim ll_Index As Long
Dim lo_ItemInfo As ItemInfo
Dim lo_ListItem As ListItem

  On Error GoTo CleanUp
  Call mo_UI.SetRedraw(ListView.hwnd, False)
  Call mo_UI.SetMousePointer(False)
  Call ClearListView
    Select Case mu_Mode
      Case ListLoadMode.ModeEdit
        Checkboxes = True
        'FIRST DISPLAY CHECKED ITEMS
        For ll_Index = 1 To mo_ItemCollection.Count
          Set lo_ItemInfo = mo_ItemCollection(ll_Index)
          If lo_ItemInfo.Checked Then Call AddListItem(lo_ItemInfo)
        Next
        'NEXT DISPLAY UNCHECKED ITEMS
        For ll_Index = 1 To mo_ItemCollection.Count
          Set lo_ItemInfo = mo_ItemCollection(ll_Index)
          If Not lo_ItemInfo.Checked Then Call AddListItem(lo_ItemInfo)
        Next
      Case ListLoadMode.ModeView
        'DISPLAY ALL WITHOUT CHECKBOXES
        Checkboxes = False
        For ll_Index = 1 To mo_ItemCollection.Count
          Set lo_ItemInfo = mo_ItemCollection(ll_Index)
          If lo_ItemInfo.Checked Then Call AddListItem(lo_ItemInfo)
        Next
    End Select
CleanUp:
  Call mo_UI.SetMousePointer(True)
  Call mo_UI.SetRedraw(ListView.hwnd, True)
  Call AutoSize
End Sub

Public Property Get Checkboxes() As Boolean
  Checkboxes = ListView.Checkboxes
End Property

Public Property Let Checkboxes(ByVal vNewValue As Boolean)
  ListView.Checkboxes = vNewValue
End Property

Public Property Get HeaderNames() As Variant
  HeaderNames = mv_HeaderNames
End Property

Public Property Let HeaderNames(ByVal vNewValue As Variant)
Dim ll_Index As Long
  
  Call mo_UI.SetVarArray(vNewValue, mv_HeaderNames)
  For ll_Index = 0 To Columns - 1
    ListView.ColumnHeaders(ll_Index + 1).Text = CStr(mv_HeaderNames(ll_Index))
  Next
End Property

Public Property Let HeaderSizes(ByVal vNewValue As Variant)
Dim ll_Index As Long

  If IsArray(vNewValue) Then
    For ll_Index = 0 To mo_UI.Min(Columns - 1, UBound(vNewValue))
      ListView.ColumnHeaders(ll_Index + 1).Width = vNewValue(ll_Index)
    Next
  End If
End Property

Public Property Get Columns() As Long
  Columns = ml_Columns
End Property

Public Property Let Columns(ByVal vNewValue As Long)
Dim ll_Index As Long
  
  If vNewValue > 0 Then
    ml_Columns = vNewValue
    ReDim mv_HeaderNames(ml_Columns - 1)
    Call ListView.ColumnHeaders.Clear
    For ll_Index = 0 To ml_Columns - 1
      Call ListView.ColumnHeaders.Add
    Next
  End If
End Property

Private Function SaveItem(ByRef lo_ListInfo As ItemInfo, ByVal lb_Checked As Boolean, ByRef ao_listItem As ListItem) As Boolean
Dim ll_cursor As Long
Dim lb_Saved As Boolean
Dim ls_Request As String
Dim ll_Index As Long
Dim ll_Count As Long
Dim i As Integer

    lb_Saved = False
    RaiseEvent ItemSave(lo_ListInfo, MasterID, lo_ListInfo.Id, lb_Checked, lb_Saved)
    If Not lb_Saved Then
        If mo_UI.IsValidCursor(EditRequest) Then
        Else
            ls_Request = IIf(lb_Checked, CheckRequest, UnCheckRequest)
            ls_Request = mo_UI.ReplacePlaceHolder(ls_Request, 0, MasterID)
            ls_Request = mo_UI.ReplacePlaceHolder(ls_Request, 1, lo_ListInfo.Id)
            For ll_Count = 1 To ao_listItem.ListSubItems.Count
                ls_Request = mo_UI.ReplacePlaceHolder(ls_Request, ll_Count, ao_listItem.ListSubItems(ll_Count).Text)
            Next
            ll_cursor = mo_ArmDb.OpenSQL(ls_Request)
            If ll_cursor <> 0 Then
                lb_Saved = True
                If lb_Checked Then RaiseEvent ItemAdded(MasterID, lo_ListInfo.Id)
            End If
            mo_ArmDb.Close ll_cursor
        End If
    End If
    SaveItem = lb_Saved
End Function

Public Function SaveList() As Boolean
Dim ll_Index As Long
Dim lo_ListItem As ListItem
Dim lo_ItemInfo As ItemInfo
Dim lb_Success As Boolean

    SaveList = False
    
    On Error GoTo CleanUp_Err
    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then Exit Function
    
    If (Mode = ListLoadMode.ModeEdit) And (mb_ItemsLoaded) Then
        'FIRST SAVE UNCHECKED - DELETE - BECAUSE OF INTEGRITY
        For ll_Index = 1 To Count
            Set lo_ListItem = ListView.ListItems(ll_Index)
            If Not lo_ListItem.Checked Then
                Set lo_ItemInfo = lo_ListItem.Tag
                If (lo_ListItem.Checked <> lo_ItemInfo.Checked) Or (lo_ItemInfo.DataChanged) Then
                    lb_Success = SaveItem(lo_ItemInfo, lo_ListItem.Checked, lo_ListItem)
                    If Not lb_Success Then GoTo CleanUp_Err
                    lo_ItemInfo.Checked = lo_ListItem.Checked
                End If
            End If
        Next
        'SECOND SAVE CHECKED - ADD - BECAUSE OF INTEGRITY
        For ll_Index = 1 To Count
            Set lo_ListItem = ListView.ListItems(ll_Index)
            If lo_ListItem.Checked Then
                Set lo_ItemInfo = lo_ListItem.Tag
                If (lo_ListItem.Checked <> lo_ItemInfo.Checked) Or (lo_ItemInfo.DataChanged) Then
                    lb_Success = SaveItem(lo_ItemInfo, lo_ListItem.Checked, lo_ListItem)
                    If Not lb_Success Then GoTo CleanUp_Err
                    lo_ItemInfo.Checked = lo_ListItem.Checked
                End If
            End If
        Next
    
    End If
    'Call LoadList

    SaveList = True
    
CleanUp_Err:
End Function

Public Property Get Count() As Long
  Count = ListView.ListItems.Count
End Property



Public Property Get AllItemsLoaded() As Boolean
  AllItemsLoaded = mb_ItemsLoaded
End Property


Public Sub UnCheckAll()
  Call UncheckCollection
  Call Display
End Sub

Public Sub AutoSize()
Dim ll_Index As Long
Dim ll_Width As Long

    For ll_Index = 0 To ListView.ColumnHeaders.Count - 1
      If ListView.ColumnHeaders(ll_Index + 1).Width > 0 Then
        ll_Width = SendMessage(ListView.hwnd, LVM_GETCOLUMNWIDTH, ByVal ll_Index, ByVal 0)
        Call SendMessage(ListView.hwnd, LVM_SETCOLUMNWIDTH, ByVal ll_Index, ByVal LVSCW_AUTOSIZE_USEHEADER)
        If ll_Width > SendMessage(ListView.hwnd, LVM_GETCOLUMNWIDTH, ByVal ll_Index, ByVal 0) Then
          Call SendMessage(ListView.hwnd, LVM_SETCOLUMNWIDTH, ByVal ll_Index, ByVal ll_Width)
        End If
      End If
    Next
End Sub

Public Property Get ShowHeader() As Boolean
  ShowHeader = Not ListView.HideColumnHeaders
End Property

Public Property Let ShowHeader(ByVal vNewValue As Boolean)

  ListView.HideColumnHeaders = Not vNewValue
End Property

Public Sub ClearAdditionalData()
Dim ll_Index As Long
Dim lo_ItemInfo As ItemInfo

  For ll_Index = 1 To mo_ItemCollection.Count
    Set lo_ItemInfo = mo_ItemCollection.Item(ll_Index)
    lo_ItemInfo.Clear
  Next
End Sub

Public Sub Unload_A_COM()
  Call Clear
  Set mo_ItemCollection = Nothing
  ASC_DisconnectFromDB mo_ArmDb, ms_UID, mb_Created
End Sub

Public Property Get ListItems() As ListItems
  Set ListItems = ListView.ListItems
End Property

Public Property Get ItemInfo(ll_Index) As ItemInfo
  If (ll_Index >= 0) And (ll_Index < mo_ItemCollection.Count) Then
    Set ItemInfo = mo_ItemCollection(ll_Index + 1)
  End If
End Property

Public Property Get ColumnHeaders() As ColumnHeaders
  Set ColumnHeaders = ListView.ColumnHeaders
End Property

Public Property Get ItemInfoCount() As Variant
  ItemInfoCount = mo_ItemCollection.Count
End Property

Public Property Get Enabled() As Boolean
  Enabled = ListView.Enabled
End Property

Public Property Let Enabled(ByVal vNewValue As Boolean)
  ListView.Enabled = vNewValue
End Property

Public Sub Add(ls_Caption As String, Optional lv_ID As Variant = "", Optional lv_Data As Variant, Optional lb_Checked As Boolean = False, Optional lb_ReadOnly As Boolean = False)
Dim lo_ItemInfo As New ItemInfo
Dim ll_Index As Long

  With lo_ItemInfo
    .Caption = ls_Caption
    .Id = lv_ID
    .Checked = lb_Checked
    .ReadOnly = lb_ReadOnly
    .DataChanged = True
    If IsArray(lv_Data) Then
      Call .SetDataSize(UBound(lv_Data))
      For ll_Index = 0 To UBound(lv_Data)
        Call .SetData(ll_Index, lv_Data(ll_Index))
      Next
    Else
      Call .SetDataSize(0)
      Call .SetData(0, lv_Data)
    End If
  End With
  Call mo_ItemCollection.Add(lo_ItemInfo)
  
End Sub

Public Property Get CheckedCount() As Long
Dim ll_Index As Long, ll_Count As Long
  If Mode = ListLoadMode.ModeView Then
    CheckedCount = Count
  Else
    ll_Count = 0
    For ll_Index = 1 To Count
      If ListItems(ll_Index).Checked Then ll_Count = ll_Count + 1
    Next
    CheckedCount = ll_Count
  End If
End Property

Public Property Get Font() As Object
  Set Font = ListView.Font
End Property

Property Get FirstItem() As String
Dim i As Integer
Dim Found As Boolean

    On Error GoTo FirstItem_Err

    FirstItem = ""
    i = 1
    Found = False
    If ListView.ListItems.Count > 0 Then
        While i <= ListView.ListItems.Count And Not Found
            If ListView.ListItems(i).Checked Then
                Found = True
                FirstItem = ListView.ListItems(i).Text
            End If
            i = i + 1
        Wend
    End If

    Exit Function

FirstItem_Err:
    MsgBox "FirstItem : " & Err.Description
End Property

